// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "RFUsbDemo.h"

#include "MainFrm.h"
#include "DlgDevComn.h"
#include "TestDlg.h"
#include "DlgOpenCom.h"

#include "umfh.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// Array tbSTDButton contains relevant buttons of bitmap IDB_STD_SMALL_COLOR
static TBBUTTON tbButtons[] = {
	{0, 0,				TBSTATE_ENABLED, TBSTYLE_SEP,    0, 0, 0,  0},  
	{0,	ID_FILE_NEW,	TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{1, ID_FILE_OPEN,	TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{2, ID_FILE_SAVE,	TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{0, 0,				TBSTATE_ENABLED, TBSTYLE_SEP,    0, 0, 0, -1},
	{3, ID_EDIT_CUT,	TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{4, ID_EDIT_COPY,	TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{5, ID_EDIT_PASTE,	TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{0, 0,				TBSTATE_ENABLED, TBSTYLE_SEP,    0, 0, 0, -1},
	{6, ID_APP_ABOUT,	TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{0, 0,				TBSTATE_ENABLED, TBSTYLE_SEP,    0, 0, 0,  0}
};
const int nNumButtons = sizeof(tbButtons)/sizeof(TBBUTTON);
const int nNumImages = 7;
const DWORD dwAdornmentFlags = 0; // exit button

extern CurCardtype;
/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	ON_WM_CREATE()
	ON_COMMAND(ID_OPEN,OnMenuComopen)
	ON_COMMAND(ID_CLOSE,OnMenuComClose)
	ON_COMMAND(ID_EXIT,OnMenuExit)
	ON_COMMAND(ID_MENU_COMN,OnMenuDevComn)
	ON_COMMAND(ID_MENU_M1,OnMenuM1Oper)
	ON_COMMAND(ID_MENU_FCPU,OnMenuFCPU)
	ON_COMMAND(ID_MENU_DESFIRE,OnMenuDesfire)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
	icdev = -1;
	CurCardtype=0;
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// Add the buttons and adornments to the CommandBar.
	if (!InsertButtons(tbButtons, nNumButtons, IDR_MAINFRAME, nNumImages) ||
	    !AddAdornments(dwAdornmentFlags))
	{
		TRACE0("Failed to add toolbar buttons\n");
		return -1;
	}

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs


	return TRUE;
}
void CMainFrame::OnMenuComopen()
{
	CDlgOpenCom dlg;
	dlg.DoModal();

}
void CMainFrame::OnMenuComClose()
{
	if(-1!=icdev)
		fw_exit(icdev);
	icdev = -1;

	AfxMessageBox(L"device close success");
}

void CMainFrame::OnMenuExit()
{
	SendMessage(WM_CLOSE,0,0);

	if(icdev!= -1)
		fw_exit(icdev);

}
void CMainFrame::OnMenuDevComn()
{
	CDlgDevComn dlg;
	dlg.DoModal();

}

void CMainFrame::OnMenuM1Oper()
{
	CurCardtype=1;//m1
	CTestDlg dlg;
	dlg.DoModal();
}
void CMainFrame::OnMenuFCPU()
{
	CurCardtype=5;
	CTestDlg dlg;
	dlg.DoModal();
}
void CMainFrame::OnMenuDesfire()
{
	CurCardtype=6;
	CTestDlg dlg;
	dlg.DoModal();

}
/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers
